/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.parts;

import appeng.api.ids.AETags;
import appeng.api.implementations.items.IFacadeItem;
import appeng.api.parts.IFacadePart;
import appeng.api.parts.IPartHost;
import appeng.api.parts.PartHelper;
import appeng.core.AEConfig;
import appeng.core.definitions.AEItems;
import appeng.facade.FacadePart;
import appeng.items.AEBaseItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;

public class FacadeItem
extends AEBaseItem
implements IFacadeItem {
    private static final String NBT_ITEM_ID = "item";

    public FacadeItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        if (stack.m_41720_() != this) {
            return InteractionResult.PASS;
        }
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        FacadePart facade = this.createPartFromItemStack(stack, context.m_43719_());
        if (facade == null || !FacadeItem.placeFacade(facade, level, pos)) {
            return InteractionResult.PASS;
        }
        if (!level.f_46443_ && player != null && !player.m_7500_()) {
            stack.m_41769_(-1);
            if (stack.m_41619_()) {
                player.m_21008_(context.m_43724_(), ItemStack.f_41583_);
            }
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public static boolean canPlaceFacade(IPartHost host, IFacadePart facade) {
        if (host.getPart(null) == null) {
            return false;
        }
        return host.getFacadeContainer().canAddFacade(facade);
    }

    private static boolean placeFacade(FacadePart facade, Level level, BlockPos blockPos) {
        IPartHost host = PartHelper.getPartHost(level, blockPos);
        if (host == null) {
            return false;
        }
        if (!FacadeItem.canPlaceFacade(host, facade)) {
            return false;
        }
        if (!host.getFacadeContainer().addFacade(facade)) {
            return false;
        }
        host.markForSave();
        host.markForUpdate();
        return true;
    }

    public static IFacadePart createFacade(ItemStack held, Direction side) {
        if (held.m_41720_() instanceof IFacadeItem) {
            return ((IFacadeItem)held.m_41720_()).createPartFromItemStack(held, side);
        }
        return null;
    }

    public Component m_7626_(ItemStack is) {
        try {
            ItemStack in = this.getTextureItem(is);
            if (!in.m_41619_()) {
                return super.m_7626_(is).m_6881_().m_130946_(" - ").m_7220_(in.m_41786_());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return super.m_7626_(is);
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
    }

    public ItemStack createFacadeForItem(ItemStack itemStack, boolean returnItem) {
        boolean isBlockAllowed;
        Item item;
        if (itemStack.m_41619_() || itemStack.m_41782_() || !((item = itemStack.m_41720_()) instanceof BlockItem)) {
            return ItemStack.f_41583_;
        }
        BlockItem blockItem = (BlockItem)item;
        Block block = blockItem.m_40614_();
        if (block == Blocks.f_50016_) {
            return ItemStack.f_41583_;
        }
        BlockState blockState = block.m_49966_();
        boolean areBlockEntitiesEnabled = AEConfig.instance().isBlockEntityFacadesEnabled();
        boolean isWhiteListed = block.m_204297_().m_203656_(AETags.FACADE_BLOCK_WHITELIST);
        boolean isModel = blockState.m_60799_() == RenderShape.MODEL;
        BlockState defaultState = block.m_49966_();
        boolean isBlockEntity = defaultState.m_155947_();
        boolean isFullCube = defaultState.m_60796_((BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.f_121853_);
        boolean isBlockEntityAllowed = !isBlockEntity || areBlockEntitiesEnabled && isWhiteListed;
        boolean bl = isBlockAllowed = isFullCube || isWhiteListed;
        if (isModel && isBlockEntityAllowed && isBlockAllowed) {
            if (returnItem) {
                return itemStack;
            }
            return this.createFacadeForItemUnchecked(itemStack);
        }
        return ItemStack.f_41583_;
    }

    public ItemStack createFacadeForItemUnchecked(ItemStack itemStack) {
        ItemStack is = new ItemStack((ItemLike)this);
        CompoundTag data = new CompoundTag();
        data.m_128359_(NBT_ITEM_ID, Registry.f_122827_.m_7981_((Object)itemStack.m_41720_()).toString());
        is.m_41751_(data);
        return is;
    }

    @Override
    public FacadePart createPartFromItemStack(ItemStack is, Direction side) {
        ItemStack in = this.getTextureItem(is);
        if (!in.m_41619_()) {
            return new FacadePart(is, side);
        }
        return null;
    }

    @Override
    public ItemStack getTextureItem(ItemStack is) {
        CompoundTag nbt = is.m_41783_();
        if (nbt == null) {
            return ItemStack.f_41583_;
        }
        ResourceLocation itemId = new ResourceLocation(nbt.m_128461_(NBT_ITEM_ID));
        Item baseItem = (Item)Registry.f_122827_.m_7745_(itemId);
        return new ItemStack((ItemLike)baseItem, 1);
    }

    @Override
    public BlockState getTextureBlockState(ItemStack is) {
        ItemStack baseItemStack = this.getTextureItem(is);
        if (baseItemStack.m_41619_()) {
            return Blocks.f_50058_.m_49966_();
        }
        Block block = Block.m_49814_((Item)baseItemStack.m_41720_());
        if (block == Blocks.f_50016_) {
            return Blocks.f_50058_.m_49966_();
        }
        return block.m_49966_();
    }

    public ItemStack createFromID(int id) {
        ItemStack facadeStack = AEItems.FACADE.stack();
        Item item = (Item)Registry.f_122827_.m_7942_(id);
        if (item == Items.f_41852_) {
            return ItemStack.f_41583_;
        }
        CompoundTag facadeTag = new CompoundTag();
        facadeTag.m_128359_(NBT_ITEM_ID, Registry.f_122827_.m_7981_((Object)item).toString());
        facadeStack.m_41751_(facadeTag);
        return facadeStack;
    }
}

